/* SPDX-License-Identifier: MIT */

#ifndef __AST_REG_H__
#define __AST_REG_H__

#include <linux/bits.h>

/*
 * Modesetting
 */

#define AST_IO_MM_OFFSET		(0x380)
#define AST_IO_MM_LENGTH		(128)

#define AST_IO_VGAARI_W			(0x40)

#define AST_IO_VGAMR_W			(0x42)
#define AST_IO_VGAMR_R			(0x4c)
#define AST_IO_VGAMR_IOSEL		BIT(0)

#define AST_IO_VGAER			(0x43)
#define AST_IO_VGAER_VGA_ENABLE		BIT(0)

#define AST_IO_VGASRI			(0x44)
#define AST_IO_VGADRR			(0x47)
#define AST_IO_VGADWR			(0x48)
#define AST_IO_VGAPDR		        (0x49)
#define AST_IO_VGAGRI			(0x4E)

#define AST_IO_VGACRI			(0x54)
#define AST_IO_VGACR80_PASSWORD		(0xa8)
#define AST_IO_VGACRA1_VGAIO_DISABLED	BIT(1)
#define AST_IO_VGACRA1_MMIO_ENABLED	BIT(2)
#define AST_IO_VGACRCB_HWC_16BPP	BIT(0) /* set: ARGB4444, cleared: 2bpp palette */
#define AST_IO_VGACRCB_HWC_ENABLED	BIT(1)

#define AST_IO_VGAIR1_R			(0x5A)
#define AST_IO_VGAIR1_VREFRESH		BIT(3)

/*
 * Display Transmitter Type
 */

#define TX_TYPE_MASK			GENMASK(3, 1)
#define NO_TX				(0 << 1)
#define ITE66121_VBIOS_TX		(1 << 1)
#define SI164_VBIOS_TX			(2 << 1)
#define CH7003_VBIOS_TX			(3 << 1)
#define DP501_VBIOS_TX			(4 << 1)
#define ANX9807_VBIOS_TX		(5 << 1)
#define TX_FW_EMBEDDED_FW_TX		(6 << 1)
#define ASTDP_DPMCU_TX			(7 << 1)

#define AST_VRAM_INIT_STATUS_MASK	GENMASK(7, 6)
//#define AST_VRAM_INIT_BY_BMC		BIT(7)
//#define AST_VRAM_INIT_READY		BIT(6)

/*
 * AST DisplayPort
 */

/* Define for Soc scratched reg used on ASTDP */
#define AST_DP_PHY_SLEEP		BIT(4)
#define AST_DP_VIDEO_ENABLE		BIT(0)

/*
 * CRD0[b2]: V-PLL reference clock(0b:24MHz, 1b:25MHz)
 * CRD1[b5]: DP MCU FW is executing
 * CRDC[b0]: DP link success
 * CRDF[b0]: DP HPD
 * CRE5[b0]: Host reading EDID process is done
 */
#define AST_VPLL_REF_CLOCK_25M		BIT(2)
#define ASTDP_MCU_FW_EXECUTING		BIT(5)
#define ASTDP_LINK_SUCCESS		BIT(0)
#define ASTDP_HPD			BIT(0)
#define ASTDP_HOST_EDID_READ_DONE	BIT(0)
#define ASTDP_HOST_EDID_READ_DONE_MASK	GENMASK(0, 0)

/*
 * CRB8[b1]: Enable VSYNC off
 * CRB8[b0]: Enable HSYNC off
 */
#define AST_DPMS_VSYNC_OFF		BIT(1)
#define AST_DPMS_HSYNC_OFF		BIT(0)

/*
 * CRDF[b4]: Mirror of AST_DP_VIDEO_ENABLE
 * Precondition:	A. ~AST_DP_PHY_SLEEP  &&
 *			B. DP_HPD &&
 *			C. DP_LINK_SUCCESS
 */
#define ASTDP_MIRROR_VIDEO_ENABLE	BIT(4)

#define ASTDP_EDID_READ_POINTER_MASK	GENMASK(7, 0)
#define ASTDP_EDID_VALID_FLAG_MASK	GENMASK(0, 0)
#define ASTDP_EDID_READ_DATA_MASK	GENMASK(7, 0)

/*
 * ASTDP setmode registers:
 * CRE0[7:0]: MISC0 ((0x00: 18-bpp) or (0x20: 24-bpp)
 * CRE1[7:0]: MISC1 (default: 0x00)
 * CRE2[7:0]: video format index (0x00 ~ 0x20 or 0x40 ~ 0x53)
 */
#define ASTDP_MISC0_24bpp		BIT(5)
#define ASTDP_MISC1			0
#define ASTDP_AND_CLEAR_MASK		0x00

/*
 * ASTDP resoultion table used in CRE2:
 * EX:	ASTDP_A_B_C:
 *		A: Resolution
 *		B: Refresh Rate
 *		C: Misc information, such as CVT, Reduce Blanked
 */
#define ASTDP_640x480_60		0x00
#define ASTDP_640x480_72		0x01
#define ASTDP_640x480_75		0x02
#define ASTDP_640x480_85		0x03
#define ASTDP_800x600_56		0x04
#define ASTDP_800x600_60		0x05
#define ASTDP_800x600_72		0x06
#define ASTDP_800x600_75		0x07
#define ASTDP_800x600_85		0x08
#define ASTDP_1024x768_60		0x09
#define ASTDP_1024x768_70		0x0A
#define ASTDP_1024x768_75		0x0B
#define ASTDP_1024x768_85		0x0C
#define ASTDP_1280x1024_60		0x0D
#define ASTDP_1280x1024_75		0x0E
#define ASTDP_1280x1024_85		0x0F
#define ASTDP_1600x1200_60		0x10
#define ASTDP_320x240_60		0x11
#define ASTDP_400x300_60		0x12
#define ASTDP_512x384_60		0x13
#define ASTDP_1920x1200_60		0x14
#define ASTDP_1920x1080_60		0x15
#define ASTDP_1280x800_60		0x16
#define ASTDP_1280x800_60_RB		0x17
#define ASTDP_1440x900_60		0x18
#define ASTDP_1440x900_60_RB		0x19
#define ASTDP_1680x1050_60		0x1A
#define ASTDP_1680x1050_60_RB		0x1B
#define ASTDP_1600x900_60		0x1C
#define ASTDP_1600x900_60_RB		0x1D
#define ASTDP_1366x768_60		0x1E
#define ASTDP_1152x864_75		0x1F
#define ASTDP_1600x900_60_DMT		0x51
#define ASTDP_1280x720_60		0x52
#define ASTDP_1280x960_60		0x53

#endif
