Summary:   RPM Package for ASPEED Graphics DRM Driver
Name:      ast-drm
Version: 1.15.2
Release: 7
Group:     System/Kernel
License:   GPL-2.0
Vendor:    ASPEED Technology Inc.
Source:    ast_src.tar.gz
Url:       http://www.aspeedtech.com
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: gcc
Provides: %{name}

%global debug_package %{nil}

%define _rpmfilename %%{NAME}.%%{Version}.%%{Release}.rpm
%define kver %(uname -r)

%description
RPM Package for ASPEED Graphics DRM Driver

%prep

%setup -c

%build
cd src
make clean
make modules
make modules_install

%install
rm -rf %{buildroot}
mkdir -p %{buildroot}/lib/modules/%{kver}/kernel/drivers/gpu/drm/ast
if [ -f /lib/modules/%{kver}/extra/ast.ko ]; then
	cp /lib/modules/%{kver}/extra/ast.ko %{buildroot}/lib/modules/%{kver}/kernel/drivers/gpu/drm/ast/ast.ko
else
	cp /lib/modules/%{kver}/updates/ast.ko %{buildroot}/lib/modules/%{kver}/kernel/drivers/gpu/drm/ast/ast.ko
fi

depmod -a

if which dracut >/dev/null 2>&1; then
	echo "Updating initramfs with dracut..."
	if dracut --force ; then
		echo "Successfully updated initramfs. Please reboot."
	else
		echo "Failed to update initramfs."
		echo "You must update your initramfs image for changes to take place."
		exit -1
	fi
elif which mkinitrd >/dev/null 2>&1; then
	echo "Updating initrd with mkinitrd..."
	if mkinitrd; then
		echo "Successfully updated initrd. Please reboot."
	else
		echo "Failed to update initrd."
		echo "You must update your initrd image for changes to take place."
		exit -1
	fi
else
	echo "Unable to determine utility to update initrd image."
	echo "You must update your initrd manually for changes to take place."
	exit -1
fi

%post
if which dracut >/dev/null 2>&1; then
	echo "Updating initramfs with dracut..."
	if dracut --force ; then
		echo "Successfully updated initramfs. Please reboot."
	else
		echo "Failed to update initramfs."
		echo "You must update your initramfs image for changes to take place."
		exit -1
	fi
elif which mkinitrd >/dev/null 2>&1; then
	echo "Updating initrd with mkinitrd..."
	if mkinitrd; then
		echo "Successfully updated initrd. Please reboot."
	else
		echo "Failed to update initrd."
		echo "You must update your initrd image for changes to take place."
		exit -1
	fi
else
	echo "Unable to determine utility to update initrd image."
	echo "You must update your initrd manually for changes to take place."
	exit -1
fi

%files
/lib/modules/%{kver}/kernel/drivers/gpu/drm/ast/ast.ko


